package gov.va.genisis2.model;

import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.Table;

/**
 * The Class UserType.
 * 
 * Description: In this UserType Class implements the interface Serializable and
 * defines the entity and data mapping for the dbo.User_Type Table in the
 * database.
 *
 */
@Entity
@Table(name = "User_Type", schema = "dbo")
public class UserType implements Serializable {

	/** The Constant serialVersionUID. */
	private static final long serialVersionUID = 6779886334746886792L;

	/** The user type id. */
	@Id
	@Column(name = "User_Type_id", unique = true, nullable = false)
	private int userTypeId;
	
	/** The user type desc. */
	@Column(name = "User_Type_desc", nullable = false, length = 50)
	private String userTypeDesc;
	
	/** The user role types. */
	@OneToMany(fetch = FetchType.EAGER, mappedBy = "userType")
	private Set<UserRoleType> userRoleTypes = new HashSet<>(0);

	/**
	 * Gets the user type id.
	 *
	 * @return the user type id
	 */
	public int getUserTypeId() {
		return this.userTypeId;
	}

	/**
	 * Sets the user type id.
	 *
	 * @param userTypeId the new user type id
	 */
	public void setUserTypeId(int userTypeId) {
		this.userTypeId = userTypeId;
	}

	/**
	 * Gets the user type desc.
	 *
	 * @return the user type desc
	 */
	public String getUserTypeDesc() {
		return this.userTypeDesc;
	}

	/**
	 * Sets the user type desc.
	 *
	 * @param userTypeDesc the new user type desc
	 */
	public void setUserTypeDesc(String userTypeDesc) {
		this.userTypeDesc = userTypeDesc;
	}

	/**
	 * Gets the user role types.
	 *
	 * @return the user role types
	 */
	public Set<UserRoleType> getUserRoleTypes() {
		return this.userRoleTypes;
	}

	/**
	 * Sets the user role types.
	 *
	 * @param userRoleTypes the new user role types
	 */
	public void setUserRoleTypes(Set<UserRoleType> userRoleTypes) {
		this.userRoleTypes = userRoleTypes;
	}
}
